//----------------------------------------------------------------------
/*hotdisplay CO,.LTD.*/
// Module       : HTM12864-55 
// Lanuage      : C51 Code
// Create       : 
// Version	: 1.0
// Date         : OCT-21-2016
// LCM Drive IC : ST7567
// INTERFACE    : 4_Wire-SPI
// MCU          : STC89C53RC
// VDD          : 3.3V                 
//*************************************************************************** 
#include<reg51.h>
sbit	A0=			P3^5;
sbit	RES=			P3^4;
sbit	SCK= 		    P1^6;
sbit	SDA=			P1^7;
sbit	CS1=			P3^7;

#define   Page   0xb0
//##########################################//
void Comwrite(unsigned char com);  //D???3D//
void Datawrite(unsigned char dat);

void Delay(unsigned int time);     //?3D//
char code Hanzi[]={
0xFF,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,0x09,0xF9,0x09,0xE1,0x11,0x09,0x09,0x09,
0x11,0xE1,0x01,0x19,0x09,0x09,0xF9,0x09,0x09,0x19,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x09,0xF9,0x09,0x09,0x09,0x11,0xE1,0x01,0x01,0x09,0x09,0xF9,0x09,
0x09,0x01,0x01,0x01,0x71,0x89,0x09,0x09,0x09,0x39,0x01,0x09,0xF9,0x09,0x09,0x09,
0x09,0xF1,0x01,0x01,0x01,0xC1,0x39,0xE1,0x01,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,
0x01,0x01,0x01,0x09,0x39,0xC9,0x01,0xC9,0x39,0x09,0x01,0x01,0x01,0x01,0x01,0x01,
0x01,0x01,0x01,0x09,0xF9,0x09,0x01,0x01,0x01,0x01,0x01,0xC1,0x31,0x09,0x09,0x09,
0x09,0x39,0x01,0x09,0xF9,0x09,0x09,0x09,0x11,0xE1,0x01,0x01,0x01,0x01,0x01,0xFF,
0xFF,0x00,0x00,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20,0x0F,0x10,0x20,0x20,0x20,
0x10,0x0F,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x00,0x20,0x20,0x3F,0x20,
0x20,0x00,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00,0x20,0x3F,0x21,0x01,0x01,
0x01,0x00,0x00,0x20,0x3C,0x23,0x02,0x02,0x27,0x38,0x20,0x20,0x3F,0x20,0x20,0x20,
0x20,0x30,0x00,0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x20,0x3F,0x20,0x20,0x20,0x20,0x30,0x00,0x07,0x18,0x20,0x20,0x20,
0x10,0x08,0x00,0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0xF8,0x08,0x00,0x00,0x08,0xF8,0x08,
0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x08,0xF8,0xF8,0x00,0xF8,0xF8,0x08,0x00,
0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,
0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x3F,0x21,0x01,0x01,0x21,0x3F,0x20,
0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x20,0x3F,0x00,0x3F,0x00,0x3F,0x20,0x00,
0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00,
0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00,
0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0xF8,0x08,0x08,0x08,0x10,0xE0,0x00,0xE0,0x10,0x08,0x08,0x08,0x10,0xE0,0x00,
0x18,0x08,0x08,0xF8,0x08,0x08,0x18,0x00,0x00,0x70,0x88,0x08,0x08,0x08,0x38,0x00,
0x00,0x00,0x00,0xC0,0xC0,0x00,0x00,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,
0x00,0x80,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x20,0x3F,0x20,0x20,0x20,0x10,0x0F,0x00,0x0F,0x10,0x20,0x20,0x20,0x10,0x0F,0x00,
0x00,0x00,0x20,0x3F,0x20,0x00,0x00,0x00,0x00,0x38,0x20,0x21,0x21,0x22,0x1C,0x00,
0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,0x00,0x20,0x20,0x3F,0x20,0x20,0x00,0x00,
0x00,0x30,0x28,0x24,0x22,0x21,0x30,0x00,0x00,0x1C,0x22,0x21,0x21,0x22,0x1C,0x00,
0x00,0x20,0x31,0x2E,0x0E,0x31,0x20,0x00,0x00,0x0F,0x11,0x20,0x20,0x11,0x0E,0x00,
0x00,0x07,0x04,0x24,0x24,0x3F,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
0xFF,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0x00,
0x00,0xE0,0x10,0x88,0x88,0x18,0x00,0x00,0x00,0x38,0x08,0x08,0xC8,0x38,0x08,0x00,
0x00,0x70,0x88,0x08,0x08,0x88,0x70,0x00,0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,
0x00,0xE0,0x10,0x08,0x08,0x10,0xE0,0x00,0x00,0x10,0x10,0xF8,0x00,0x00,0x00,0x00,
0x00,0x70,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x30,0x08,0x88,0x88,0x48,0x30,0x00,
0x00,0x00,0xC0,0x20,0x10,0xF8,0x00,0x00,0x00,0xF8,0x08,0x88,0x88,0x08,0x08,0xFF,
0xFF,0x8F,0x90,0xA0,0xA0,0x90,0x8F,0x80,0x80,0xA0,0xA0,0xBF,0xA0,0xA0,0x80,0x80,
0x80,0xB0,0xA8,0xA4,0xA2,0xA1,0xB0,0x80,0x80,0x98,0xA0,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x87,0x84,0xA4,0xA4,0xBF,0xA4,0x80,0x80,0x99,0xA1,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x8F,0x91,0xA0,0xA0,0x91,0x8E,0x80,0x80,0x80,0x80,0xBF,0x80,0x80,0x80,0x80,
0x80,0x9C,0xA2,0xA1,0xA1,0xA2,0x9C,0x80,0x80,0x80,0xB1,0xA2,0xA2,0x91,0x8F,0x80,
0x80,0x8F,0x90,0xA0,0xA0,0x90,0x8F,0x80,0x80,0xA0,0xA0,0xBF,0xA0,0xA0,0x80,0x80,
0x80,0xB0,0xA8,0xA4,0xA2,0xA1,0xB0,0x80,0x80,0x98,0xA0,0xA0,0xA0,0x91,0x8E,0x80,
0x80,0x87,0x84,0xA4,0xA4,0xBF,0xA4,0x80,0x80,0x99,0xA1,0xA0,0xA0,0x91,0x8E,0xFF
};

//###############################################//
char code Hanzi1[]={
0x00,0x04,0xFC,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0xA0,0xA0,0xA0,0xA0,0xC0,
0x00,0x00,0x00,0xC0,0x40,0x20,0x20,0x44,0xFC,0x00,0x00,0x00,0x00,0x20,0x20,0xE4,
0x00,0x00,0x00,0x00,0x00,0xC0,0x40,0x20,0x20,0x20,0x40,0xC0,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x84,0x84,0x84,0x44,0xF8,0x00,0x00,
0x00,0x08,0x04,0x04,0x84,0x44,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xF0,0x88,0x44,0x44,0x44,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x04,0xFC,0x30,0xC0,0x00,0xC0,0x30,0xFC,0x04,0x04,0xFC,0x44,0x40,
0x40,0x40,0x44,0xFC,0x04,0x00,0x60,0x20,0x20,0x20,0xA0,0x60,0x20,0x00,0x00,0x00,
0x40,0x48,0x4F,0x48,0x40,0x41,0x42,0x4C,0x48,0x40,0x47,0x48,0x48,0x48,0x48,0x47,
0x48,0x40,0x40,0x47,0x44,0x48,0x48,0x44,0x4F,0x48,0x40,0x40,0x40,0x48,0x48,0x4F,
0x48,0x48,0x40,0x40,0x40,0x47,0x44,0x48,0x48,0x48,0x44,0x47,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x48,0x48,0x48,0x44,0x43,0x40,0x40,
0x40,0x4C,0x4A,0x49,0x48,0x48,0x48,0x40,0x40,0x40,0x40,0x40,0x4C,0x4C,0x40,0x40,
0x40,0x40,0x40,0x47,0x48,0x48,0x48,0x48,0x47,0x40,0x40,0x40,0x40,0x40,0x40,0x40,
0x40,0x40,0x40,0x48,0x4F,0x48,0x40,0x43,0x40,0x48,0x4F,0x48,0x48,0x4F,0x48,0x40,
0x40,0x40,0x48,0x4F,0x48,0x40,0x48,0x4C,0x4A,0x49,0x48,0x48,0x4C,0x40,0x40,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,
0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,
0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0xE0,0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,
0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xE0,0xE0,0xE0,0xFC,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,0x1C,
0x1C,0x1C,0x1C,0xFC,0xE0,0xE0,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,
0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,
0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0xF0,0x00,0x00,
0x00,0x00,0x80,0x40,0x20,0x10,0x00,0x00,0x80,0x00,0x80,0x80,0x80,0x00,0x00,0x80,
0x80,0x80,0x00,0x00,0x00,0x00,0xC0,0x30,0x00,0xF0,0x00,0x80,0x80,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,
0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,
0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,
0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1F,0x1F,0x1F,0xFF,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,0xE0,
0xE0,0xE0,0xE0,0xFF,0x1F,0x1F,0x1F,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x08,0x04,
0x02,0x07,0x08,0x30,0x40,0x80,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0xFF,0x01,0x00,
0x00,0x00,0xFF,0x00,0xC0,0x3C,0x03,0x00,0x00,0xFF,0x01,0x00,0x00,0x00,0xFF,0x00,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0x84,0x44,0x44,0x44,0x84,0x04,
0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x84,0x84,0xC4,0x04,0x04,0x04,
0x04,0x04,0xC4,0x44,0x44,0x44,0x44,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,
0x04,0x84,0x44,0x44,0x44,0x84,0x04,0x04,0x04,0xC4,0x44,0x44,0x44,0x44,0x04,0x04,
0x00,0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,
0x00,0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,
0x00,0x00,0x20,0x40,0x44,0x44,0x3B,0x00,0x00,0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x7F,0x40,0x40,0x00,
0x00,0x00,0x27,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00,0x21,0x00,0x00,0x00,
0x00,0x60,0x50,0x48,0x44,0x43,0x00,0x00,0x00,0x27,0x44,0x44,0x44,0x38,0x00,0x00,
};



void Delay(unsigned int time)
{
	unsigned char j;
	while(time--)
	{	
		for(j=0;j<=50;j++)  //?20us=0.02ms//
		{}                  
	}
}


/******************************************************/
void Display(unsigned char sda,unsigned char sda1)
{
  unsigned char i,j,k=0; 
  Comwrite(0x40);
  for(i=0;i<8;i++)
	{
	Comwrite(Page+k);
	Comwrite(0x10);
	Comwrite(0x00);	
	for(j=0;j<66;j++)
	   {Datawrite(sda);
	    Datawrite(sda1);
	   }
	   k++;
	}
	
}      

/*****************************************************/

void Hanzi_Disp(void)
{
  unsigned char   i,j,k=0;
  Comwrite(0x40);
      for(i=0;i<8;i++)
	{
	  
	  Comwrite(Page+k);
	  Comwrite(0x10);
	  Comwrite(0x00);
      for(j=0;j<128;j++)	
	  {Datawrite(Hanzi[i*128+j]);}	
	  k++; 
	} 
	    
	   	 Delay(5000);  	 
}     

void Hanzi_Disp1(void)
{
  unsigned char   i,j,k=0;
  Comwrite(0x40);
      for(i=0;i<8;i++)
	{
	  
	  Comwrite(Page+k);
	  Comwrite(0x10);
	  Comwrite(0x00);
      for(j=0;j<128;j++)	
	  {Datawrite(Hanzi1[i*128+j]);}	
	  k++; 
	} 
	    
	   	 Delay(5000);  	 
}     


//#########################################################//

void Intial(void)

{  
	Delay(100);
	Comwrite(0xe3);
	Comwrite(0xA2);	//1010001/BS  duty:1/65,BS-1:1/7,0:1/9
	Comwrite(0xA0);	//Sets the display RAM address SEG output correspondence  0: normal, 1: reverse 
	Comwrite(0xc8);	//com direction  Normal direction
	Comwrite(0x2c);
	Comwrite(0x2e);
	Comwrite(0x2F);//power on :00101/Booster circuit/Voltage regulator circuit/Voltage follower circuit
	Comwrite(0xf8);//Booster Ratio Select Mode Set
	Comwrite(0x00);
	Comwrite(0x81);	//SET EV :10000001
	Comwrite(0x15);//Setting V0 Voltage:(0x00~0x3f)	 Contrast settings
	Comwrite(0x25);//regulation ration: (0x21~0x27)	 Contrast settings
	Comwrite(0xAF);	//Display ON/OFF :1010111/D  on:1
	Comwrite(0x40);	//Set Start Line
	Delay(20);					 
}

/**********************************************************/

int main()
{	
    /*PINSEL0=0x00000000;  //??y????GPIO
    																	   
    IO0DIR=SPIIOCON;    //??SPI??????a?3?*/
    

    RES=0;
	Delay(20);
	RES=1;
	Delay(20);
 while(1)           
   {   
	Intial();
	Delay(20);
      
      Display(0xFF,0xFF);
	  Delay(1000);
      Display(0x00,0x00);
	  Delay(1000);
      Display(0xFF,0x00);
	  Delay(1000);  
      Display(0x00,0xff);
	  Delay(1000); 
      Display(0x55,0xAA);
	  Delay(1000);
      Display(0xAA,0x55);
	  Delay(1000);	  
	  Hanzi_Disp();	Delay(1000);
	  Hanzi_Disp1();	
	  Delay(1000);	    
	 }
	 
}

void Comwrite(char com)

{  
    unsigned char data i,j;
	    CS1=0;
	    A0=0;  
        SCK=0;
	for(i=0;i<8;i++)
	    { 
		 j=com;
		 SCK=0;
		 SDA=com&0x80;
         SCK=1;	     
		 com=j<<1;
		}
	    CS1=1;
		A0=1;
}

//###########################################################//
void Datawrite(char dat)

{
    unsigned char data i,j;
	    CS1=0;
	    A0=1;  
        SCK=0;
	for(i=0;i<8;i++)
	    { 
		 j=dat;
		 SCK=0;
		 SDA=dat&0x80;
         SCK=1;	     
		 dat=j<<1;
		}
	    CS1=1;
		A0=0;
}
